package gov.va.med.domain.service.messaging.encode.hl7.util;

import java.security.SecureRandom;

import gov.va.med.domain.service.messaging.MessagingConstants;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.v23.datatype.RCD;
import ca.uhn.hl7v2.model.v23.segment.MSH;
import ca.uhn.hl7v2.model.v23.segment.RDF;

/**
 * HL7v23Helper
 *
 * @author Slava Uchitel
 * @version $Id: HL7v23Helper.java,v 1.1.1.1 2005/05/13 19:40:43 jon.crater Exp $
 * @since MHV 2.0 <br>Mar 1, 2005
 */
public class HL7v23Helper extends HL7Helper
{ 
	public static void fillMSHSegment(MSH msh, HL7HeaderParameters params)
	throws DataTypeException                                   
	{
		fillMSHSegment(msh,
				       params.getFieldSeparator(), params.getDelimiters(),
				       params.getEvent(), params.getTrigger(),
					   params.getSrcStationNumber(), params.getSrcDomain(), params.getSrcApplication(),
					   params.getDstStationNumber(), params.getDstDomain(), params.getDstApplication(),
					   params.getSystemType(), params.getMessageControlId(),
					   params.getAcceptAcknowledgmentType(), params.getApplicationAcknowledgmentType());
	}

	public static void fillMSHSegment(MSH msh, 
                                  String fieldSeparator, String delimiters, 
                                  String event, String trigger,
                                  String srcStationNumber, String srcDomain, String srcApplication,
                                  String dstStationNumber, String dstDomain, String dstApplication,
                                  String systemType, String messageControlId,
                                  String acceptAcknowledgmentType, String applicationAcknowledgmentType)
    throws DataTypeException                                   
    {
        srcDomain=(srcDomain==null)?MessagingConstants.EMPTY_STRING:srcDomain.trim();
        dstDomain=(dstDomain==null)?MessagingConstants.EMPTY_STRING:dstDomain.trim();
       
        msh.getFieldSeparator().setValue(fieldSeparator);
        msh.getEncodingCharacters().setValue(delimiters);
       
        msh.getSendingApplication().getNamespaceID().setValue(srcApplication);
        msh.getSendingFacility().getNamespaceID().setValue(srcStationNumber);
        msh.getSendingFacility().getUniversalID().setValue(srcDomain);
        msh.getSendingFacility().getUniversalIDType().setValue(srcDomain.length()>0?"DNS":MessagingConstants.EMPTY_STRING);
       
        msh.getReceivingApplication().getNamespaceID().setValue(dstApplication);
        msh.getReceivingFacility().getNamespaceID().setValue(dstStationNumber);
        msh.getReceivingFacility().getUniversalID().setValue(dstDomain);
        msh.getReceivingFacility().getUniversalIDType().setValue(dstDomain.length()>0?"DNS":MessagingConstants.EMPTY_STRING);
        msh.getDateTimeOfMessage().setValue(getMessageDateTime());
	    
        msh.getMessageType().getMessageType().setValue(event);
        msh.getMessageType().getTriggerEvent().setValue(trigger);
        if (messageControlId == null || messageControlId.trim().length() == 0)
          messageControlId = String.valueOf(System.currentTimeMillis())+String.valueOf(Math.abs(new SecureRandom().nextLong()));
        msh.getMessageControlID().setValue(messageControlId);
        msh.getProcessingID().getProcessingID().setValue(systemType); 
        msh.getVersionID().setValue("2.3");
        if (acceptAcknowledgmentType != null)
            msh.getAcceptAcknowledgementType().setValue(acceptAcknowledgmentType);
        if (applicationAcknowledgmentType != null)
            msh.getApplicationAcknowledgementType().setValue(applicationAcknowledgmentType);
    }
   
    public static void fillRdfSegment(RDF rdf, String[][] fieldDefs)
    throws HL7Exception
    {
        rdf.getNumberOfColumnsPerRow().setValue(String.valueOf(fieldDefs.length));
        for (int i=0; i<fieldDefs.length; i++)
        {
            RCD rcd = rdf.getColumnDescription(i);
            rcd.getHL7ItemNumber().setValue(fieldDefs[i][0]);
		    rcd.getHL7DateType().setValue(fieldDefs[i][1]);
		    rcd.getMaximumColumnWidth().setValue(fieldDefs[i][2]);    
        }
    }
    
} 
